//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : work_mode_polling.c
// Description: 
//Targer Board: 
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"


u8	gu8v_halt_time;
u8	gu8v_work_mode;
u8	gu8v_sys_time;
u8	gu8v_public_time;
u8	gu8v_public_count;
u8	gu8v_public_count1;
u8	gu8v_heart_count;
u8	gu8v_err_code;
u8	gu8v_Measure_display_mode;
volatile	__byte_type		gu8v_time_flag;
__byte_type		gu8v_sys_flag;
__byte_type		gu8v_setting_flag;

u8	gu8v_unit_setting_time;
u16	gu8v_BAT_ADC;

u32	gu32v_scf_sum;


u16	gu16v_pressure_max;
u16	gu16v_pressure_min;
u8	gu8v_filter_guide;
u8	gu8v_user_num;

/********************************************************************
Function:	fun_work_polling
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
inline	void	 fun_work_polling(void)
{
	//10ms polling
//	if(gbv_work_polling)
//	{
//	if(_ptm2af)
//	{	
//		_ptm2af = 0;
//		gbv_work_polling = 0;
//		sys_time();
//		fun_Key_Scan();		
//		fun_En_Analog_power();		
//		fun_iir_filter(fun_Get_ADC(AN5));
//		fun_iir_filter1(fun_Get_ADC(AN6));
//		fun_cal_pressure(gu16v_pressure_output);	
//		switch(gu8v_work_mode)
//		{
//			case	Sys_Normal_mode:
//				Sys_Normal();				
//			break;
//			case	Sys_Power_On_mode:
//				Sys_Power_On();
//			break;
//
//			case	Sys_Time_Dis_mode:
////				Sys_Time_Dis();
//			break;
//
//			case	Sys_Measure_mode:
//				Sys_Measure();
//				//Sys_Measure_test();
//				
//			break;
//
//			case	Sys_Find_History_mode:
//				Sys_Find_History();
//			break;		
//
//			case	Sys_Set_Time_mode:
//				Sys_Set_Time();
//			break;	
//
//			case	Sys_Pressure_Test_mode:
//				Sys_Pressure_Test();
//			break;	
//
//			case	Sys_Calibration_mode:
//				Sys_Calibration_Time();
//			break;	
//			case	Sys_Comparison_mode:
//				Sys_Comparison();
//			break;	
//			case	Sys_HALT_mode:
//				Sys_HALT();
//			break;			
//			default :
//				Change_Mode(Sys_Normal_mode);
//			break;
//
//		}
//	}
	
	
}
u8	gu8v_tb1_count;
/********************************************************************
Function:	fun_500ms_polling
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void fun_500ms_polling(void)
{
	if(_tb1f)
	{

		_tb1f = 0;
		gbv_tb1_flag = 1;
		gu8v_tb1_count++;
		if(gu8v_tb1_count>=1)
		{
			gu8v_tb1_count = 0;
			gu8v_halt_time ++;
			if(gu8v_halt_time>=LU8C_HALT_TIME)
			{
				gu8v_halt_time = LU8C_HALT_TIME;
			}
			gu8t_time_second ++;
			
			//sɶ
			gbv_uptime = 1;
			if(gbv_uptime)
			{								
			}
			
			
			if(gu8t_time_second == 120)
			{
				gu8t_time_second=0;
				gu8t_time_minute++;
	
				if(gu8t_time_minute==60)
				{
					gu8t_time_minute=0;
					gu8t_time_hour++;
					if(gu8t_time_hour==24)
					{
						gu8t_time_hour=0;
	
						if(fun_TIME_ADD1(2))
						{
							if(fun_TIME_ADD1(1))
							{
								fun_TIME_ADD1(0);						
							}
						}
					}		
				}
			}			
		}		
	}
}



/********************************************************************
Function:	Change_Mode
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void Change_Mode(u8 lu8v_work_mode)
{
	gu8v_work_mode = lu8v_work_mode;
	gu8v_public_time = 0;
	gu8v_public_count = 0;
	gu8v_public_count1 = 0;	
	fun_LCD_all(0);
	gu8v_Key_status.u8 = 0;
//	gu16a_wave_time_sharing = 0;
}

/********************************************************************
Function:	Sys_HALT
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void Sys_HALT()
{
	gu8v_halt_time = LU8C_HALT_TIME;
	
}



/********************************************************************
Function:	Sys_Normal
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void Sys_Normal()
{
	
	switch(gu8v_public_count)
	{
		case	0:
			
			fun_LCD_INIT();
			fun_LCD_Disable();			
			if(gbv_start_click)
			{
				gbv_start_click = 0;
				gu8v_public_count = 2;	
				fun_LCD_INIT();
				fun_LCD_Enable();					
			}
			if(gbv_memory_click)
			{
				gbv_memory_click =
				gu8v_public_count = 1;					
				fun_LCD_INIT();
				fun_LCD_Enable();					
			}	
//			if(gbv_set_long_Press)
//			{
//				gbv_set_long_Press = 0;
//				gu8v_public_count = 3;					
//				fun_LCD_INIT();
//				fun_LCD_Enable();					
//			}			
			if(gbv_set_click)
			{
				gbv_set_click = 0;
				Change_Mode(Sys_Set_user_mode);			
				fun_LCD_INIT();
				fun_LCD_Enable();					
			}		
			if(gbv_set_long_Press)
			{
				gbv_set_long_Press = 0;
				fun_LCD_INIT();
				fun_LCD_Enable();				
				//iJɶ]mҦ
				Change_Mode(Sys_Set_Time_mode);
			}					
			if(gbv_start_press)
			{
				if(gbv_500ms)
				{
					gu8v_unit_setting_time++;
					if(gu8v_unit_setting_time>6)
					{
						gu8v_public_count = 4;	
						fun_LCD_INIT();
						fun_LCD_Enable();
						
						gbv_unit = ~gbv_unit;					
						LCD_DISP_UNIT(gbv_unit);
						LCD_DISP_KP_or_MMHG(gbv_unit,0,0);
												
					}	
				}
				
				
			}
		break;
		case	1:
			// 2S
			//ﾹ 2S
			//iJd߼Ҧ			
			fun_LCD_all(0xff);
			gu8v_public_time ++;
			if(gu8v_public_time>200)
			{
				gu8v_public_time = 200;				
				//iJdݾvOҦ
				Change_Mode(Sys_Find_History_mode);
				
			}

			
		
		break;		
		case	2:
		
		
			
			// 2S	
			//ﾹ 2S
			//2S FP_O_
			fun_LCD_all(0xff);
			gu8v_public_time ++;
			if(gu8v_public_time>200)
			{
				gu8v_public_time = 200;
				if(gbv_start_press == 0)
				{
					//iJqҦ
					Change_Mode(Sys_Measure_mode);	
					Sys_init_heart_wave();
					//˴
					fun_battery_check();				
				}
//				if(gbv_start_long_Press)
//				{
//					//iJɶ]mҦ
//					Change_Mode(Sys_Set_Time_mode);
//				}
				
			}			
				
		break;	
		case	3:
//			if(gbv_set_long_Press)
//			{
//				gbv_set_long_Press = 0;
//				//iJɶ]mҦ
//				Change_Mode(Sys_Set_Time_mode);
//			}			
		break;		
		case	4:
			gu8v_public_time ++;
			if(gu8v_public_time>200)
			{
				gu8v_public_time = 0;
				Change_Mode(Sys_HALT_mode);	
			}					
		break;		
				
		
	}
	




}	

/********************************************************************
Function:	sys_time
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void sys_time()
{
	gu8v_sys_time++;
	if(gu8v_sys_time == 25)
	{
		gbv_250ms = 1;
		gbv_250ms_tigger = ~gbv_250ms_tigger;
			
	}
	else if(gu8v_sys_time>=50)
	{
		gu8v_sys_time = 0;
		gbv_250ms = 1;
		gbv_250ms_tigger = ~gbv_250ms_tigger;
		gbv_500ms = 1;
		gbv_500ms_tigger = ~gbv_500ms_tigger;
	}
}

/********************************************************************
Function:	sys_time_init
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void sys_time_init()
{
	gu8v_sys_time = 0;
	gbv_250ms = 0;
	gbv_250ms_tigger = 1;
	gbv_500ms = 0;
	gbv_500ms_tigger = 1;
}

/********************************************************************
Function:	Sys_Power_On
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
inline	void 	Sys_Power_On()
{
	//LCD DISPLAY 2S
	//pGstart ʧ@p3iJ]mɶҦ
	//pGstart ʧ@p3-4iJOҦҦ
	//pGstart ʧ@p5HWiJեҦҦ	
	fun_LCD_all(0x0ff);
	if(gbv_500ms)
	{
//		gbv_500ms = 0;
		gu8v_public_time++;
		if(gu8v_public_time>=4)
		{
			gu8v_public_time = 0;
			
			//

			if(gu8v_public_count==3)
			{
				Change_Mode(Sys_Pressure_Test_mode);;
				fun_En_Analog_power();
				//gu16v_zero.u16 =  gu16v_pressure_output;
				gu8v_filter_guide = 0;
				gbv_pressure_lock = 0;
				gu16v_pressure_max = 0;
				gu16v_pressure_min = 300;
			}
			else if(gu8v_public_count==5)
			{
				Change_Mode(Sys_Calibration_mode);
				fun_En_Analog_power();
			}
			else if(gu8v_public_count==7)
			{
				Change_Mode(Sys_T1_mode);
				fun_En_Analog_power();
			}			
			else
			{
				#ifndef	Debug
					//gu8v_work_mode = Sys_Set_Time_mode;
				#else
					//gu8v_work_mode = 0;
				#endif
					goto_halt();
				
				
			}			
			gu8v_public_count= 0;
			fun_LCD_all(0);

		}
	}
	//
	if(gbv_start_click)
	{
		gbv_start_click = 0;
		gu8v_public_time = 2;
		gu8v_public_count ++;
		
	}
}


/********************************************************************
Function:	Sys_Time_Dis
INPUT	:
OUTPUT	:	
NOTE	:    8
********************************************************************/
inline	void 	Sys_Time_Dis()
{


}


/********************************************************************
Function:	Sys_init_heart_wave
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
inline	void 	Sys_init_heart_wave()
{
//	gu8a_heart_wave_maximum = gu8a_heart_wave_data;
//	gu8a_heart_wave_minimum = gu8a_heart_wave_data;
//	gu16a_wave_time_sharing = 0;
	gu32v_scf_sum = 0;
}






/********************************************************************
Function:	Sys_Find_History
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
inline	void 	Sys_Find_History()
{	
	
	fun_LCD_user(LBC_SET,gu8v_user_num);
	switch(gu8v_public_count) 
	{
	   	case 0:	
	   	//up {{XUiJ3ըD
//		 	LCD_ICON(LBC_FFLASH,LCD_DOWN_ADDR);	   	
//			LCD_UPDATA_TIME();	   			
//		   	gu8v_public_time++;
//		   	if(gu8v_public_time>150)
//		   	{
//		   		//iJռҦ
				fun_LCD_all(0);	
//				gu8v_public_time = 0;
				gu8v_public_count = 1;	
////				fun_Play_Sentence_init();			
//		   	}
		   	
	  	break;
	  			
	   	case 1:
			//3ƾ
			IAP_READ_MEMORY_3_AEG(gu8v_user_num);//gu8v_sys_flag.u8 &0x03);//
			if(gu8v_current_sn >1)
			{
//				LCD_DISP_SYS_ON(LBC_SET,lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8,0);
//				LCD_DISP_DIA_ON(LBC_SET,lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8,0);
				LCD_DISP_KP_or_MMHG(gbv_unit,lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8,lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8);	

				LCD_DISP_Pluse_ON(LBC_SET,lu8a_iap_temp[4].u8);
				//LCD_UPDATA_TIME();
				LCD_ICON(LBC_SET,LCD_AVG_ADDR);	
//				LCD_ICON(LBC_SET,LCD_mmhg_ADDR);
				LCD_DISP_UNIT(gbv_unit);
				//LCD_ICON(LBC_SET,LCD_heart_ADDR);
				LCD_ICON(LBC_SET,LCD_No_ADDR);				
				
//				fun_Play_Sentence(gu8c_arr_sentence_avg,(__16_type)gu16c_arr_sentence_avg_en,0,lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8,lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8,lu8a_iap_temp[4].u8);	
				
				
				//Ustart iJd߾vO
				if(gbv_memory_click)
				{
					gbv_memory_click = 0;		
					gu8v_public_count = 2;
					fun_LCD_all(0);	
					gu8v_search_sn = 1;	
//					fun_Play_Sentence_init();
				}
			}
			else
			{
				//ݭnd
				gu8v_public_count = 4;
				
			}
			
	  	break;
		case 2:	
			
			IAP_READ_MEMORY(gu8v_user_num,gu8v_search_sn);//
//			LCD_DISP_SYS_ON(LBC_SET,lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8,0);
//			LCD_DISP_DIA_ON(LBC_SET,lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8,0);
			LCD_DISP_KP_or_MMHG(gbv_unit,lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8,lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8);	

			LCD_DISP_Pluse_ON(LBC_SET,lu8a_iap_temp[4].u8);
			LCD_DISP_MEMORY_ON(LBC_SET,gu8v_search_sn);			
			
			//LCD_UPDATA_TIME();	
			//LCD_ICON(LBC_SET,LCD_mmhg_ADDR);
			LCD_DISP_UNIT(gbv_unit);
			//LCD_ICON(LBC_SET,LCD_heart_ADDR);			
			//LCD_DISP_MONTH_ON(LBC_SET,lu8a_iap_temp[8].u8);
			//LCD_DISP_DAY_ON(LBC_SET,lu8a_iap_temp[7].u8);	
			LCD_DISP_HOUR_ON(LBC_SET,lu8a_iap_temp[6].u8);
			LCD_DISP_MINUTE_ON(LBC_SET,lu8a_iap_temp[5].u8);
			
			
						
			//LCD_ICON(LBC_SET,LCD_COLD_ADDR);	
			LCD_ICON(LBC_SET,LCD_COL_ADDR);				
			LCD_ICON(LBC_SET,LCD_D_ADDR);
			LCD_ICON(LBC_SET,LCD_M_ADDR);		
			LCD_ICON(LBC_SET,LCD_No_ADDR);	
			
//			fun_Play_Sentence(gu8c_arr_sentence_memory,(__16_type)gu16c_arr_sentence_memory_en,gu8v_search_sn,lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8,lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8,lu8a_iap_temp[4].u8);	
						
			if(gbv_memory_click)
			{
				gbv_memory_click = 0;		
				//gu8v_public_count = 3;
				fun_LCD_all(0);	
				gu8v_search_sn ++;
				if(gu8v_search_sn>=gu8v_current_sn)
				{
					gu8v_search_sn = 1;
					
				}	
			}			

	  	break;		
	   	case 3:
//			//ܬdߪƾ
//			LCD_DISP_DIA_ON(LBC_CLR,0);
//			LCD_DISP_SYS_ON(LBC_CLR,0);
//			LCD_DISP_MEMORY_ON(LBC_SET,gu8v_search_sn);
//			//LCD_UPDATA_TIME();
//			LCD_ICON(LBC_CLR,LCD_AVG_ADDR);	
//			LCD_ICON(LBC_SET,LCD_No_ADDR);
//			gu8v_public_time++;
//			if(gu8v_public_time>100&&gbv_memory_press==0)
//			{
//				gu8v_public_time = 0;
//				gu8v_public_count = 2;				
//				
//			}		
//			if(gbv_memory_click)
//			{
//				gu8v_public_time = 0;
//				gbv_memory_click = 0;		
//				fun_LCD_all(0);	
//				gu8v_search_sn ++;
//				if(gu8v_search_sn>=gu8v_current_sn)
//				{
//					gu8v_search_sn = 1;
//					
//				}	
//			}	
//			fun_Play_Sentence_init();		
	  	break;
		case 4:	
			// ---
			LCD_DISP_SYS_ON(LBC_CLR,0,0);
			LCD_DISP_DIA_ON(LBC_CLR,0,0);
			LCD_DISP_Pluse_ON(LBC_CLR,0);	
			LCD_DISP_MEMORY_ON(LBC_CLR,0);				
			LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,0,Display__,Display__,Display__);			
			LCD_ICON(LBC_CLR,LCD_AVG_ADDR);	
			LCD_ICON(LBC_CLR,LCD_mmhg_ADDR);
			LCD_ICON(LBC_CLR,LCD_Kpa_ADDR);			
			LCD_ICON(LBC_CLR,LCD_heart_ADDR);									
			LCD_ICON(LBC_CLR,LCD_No_ADDR);	
			LCD_ICON(LBC_CLR,LCD_POINT1_ADDR);
			LCD_ICON(LBC_CLR,LCD_POINT2_ADDR);				
			//gu8v_public_time++;
			//if(gu8v_public_time>200)
			{
				gu8v_public_time = 0;
				gu8v_public_count = 5;					
				
			}						
	  	break;	  	
		case 5:	
			//LCD_DISP_DIA_ON(LBC_SET,0);
			//LCD_DISP_SYS_ON(LBC_SET,0);
			LCD_DISP_Pluse_ON(LBC_CLR,0);
			LCD_UPDATA_TIME();
			//LCD_ICON(LBC_SET,LCD_mmhg_ADDR);
			LCD_DISP_UNIT(gbv_unit);			
			
			gu8v_public_time++;
			if(gu8v_public_time>200)
			{
				gu8v_public_time = 0;
				Change_Mode(Sys_HALT_mode);				
			}

	  	break;
		default :
			
			
		break;
	}	
	
	//Ustart iJίv
	if(gbv_start_click||gbv_start_long_Press)
	{
		gbv_start_click = 0;
		gbv_start_long_Press = 0;
		Change_Mode(Sys_HALT_mode);
		
	
	}	
	
	//start Mƾ
	if(gbv_memory_long_Press)
	{
		gbv_memory_long_Press = 0;	
		//MeΤƾ
		IAP_ERASE_MEMORY(gu8v_user_num);
		gu8v_public_count = 4;	
		gu8v_public_time = 0;							
	}		
	
}



/********************************************************************
Function:	Sys_Set_user
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Sys_Set_user()
{
//	u8	lu8v_user;

	
	if(gbv_set_click)
	{
		gbv_set_click = 0;
		gu8v_user_num++;
		if(gu8v_user_num>1)
		{
			gu8v_user_num = 0;
		}
	}	
	
	
	if(gu8v_user_num==0)
	{
		LCD_ICON(LBC_FFLASH,LCD_User1_ADDR);		
		LCD_ICON(LBC_CLR,LCD_User2_ADDR);		
	}
	else if(gu8v_user_num==1)
	{
		LCD_ICON(LBC_FFLASH,LCD_User2_ADDR);		
		LCD_ICON(LBC_CLR,LCD_User1_ADDR);			
		
	}
	

	
	
	if(gbv_start_click)
	{
		gbv_start_click	= 0;
		Change_Mode(Sys_HALT_mode);
	}
	
	
}



///********************************************************************
//Function:	Sys_Set_Time
//INPUT	:
//OUTPUT	:	
//NOTE	:   
//********************************************************************/
//void 	Sys_Set_Time()
//{
//
//
//}


/********************************************************************
Function:	Sys_Pressure_Test_Time
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
inline	void 	Sys_Pressure_Test()
{

	switch(gu8v_public_count)
	{
		case	0:
		   	if(gbv_pressure_lock)
		   	{
		   		if(gu16v_current_pressure.u16<20)
		   		{
					gu16v_zero.u16 =  gu16v_pressure_output;		   			
		   			gu8v_public_count++;
		   		}
		   		else
		   		{
				   	gu8v_public_count =4;						   			
			   		gu8v_err_code = 8;				   					
		   		}		   		
		   		
		   	}
			   					
		break;
		case	1:
			//ܷeO
			STP_VALUE_ON();
			//fun_cal_pressure(gu16v_pressure_output);
			if(gbv_250ms)
			{
				LCD_DISP_SYS_ON(LBC_SET,gu16v_current_pressure.u16,0);
				LCD_DISP_DIA_ON(LBC_SET,gu16v_scf_output_ybuff[0]/16,0);		
				LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,2,Display_all_off,Display_P,Display_1);	
			}
		//	Uart_putchar(0x55);			
		//	Uart_putchar(gu16v_current_pressure.byte.byte0);			
		//	Uart_putchar(gu16v_current_pressure.byte.byte1);
		////	Uart_putchar(gu8v_public_count);						
		//	Uart_putchar(gu16v_scf_output_ybuff[0]/16);	
		//	Uart_putchar(0);				
		//	Uart_putchar(0x55+gu16v_current_pressure.byte.byte0+gu16v_current_pressure.byte.byte1+gu16v_scf_output_ybuff[0]/16);		
		//	Uart_putchar(10);						
		break;			
		case	2:
		
		break;		
	   	case 4:
	   		//ERR
			STP_PUMP_OFF();
			STP_VALUE_OFF();	 
	   		LCD_UPDATA_ERR(gu8v_err_code);				
			LCD_DISP_DIA_ON(LBC_HID,gu16v_dia,0);
			LCD_DISP_SYS_ON(LBC_CLR,gu16v_sys,0);	
			LCD_DISP_Pluse_ON(LBC_CLR,gu8v_heart);	
				   		
	   	break;
	   			
	}
		


		



}

/********************************************************************
Function:	Sys_Calibration_Time
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
inline	void 	Sys_Calibration_Time()
{	
	STP_VALUE_ON();
	//ܮեҦ p	C1 C2 C3
	LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,2,Display_all_off,Display_c,Display_1);
	//ܷeADCK
	LCD_DISP_DIA_ON(LBC_SET,gu16v_pressure_output/16,0);	
	if(gu8v_public_count == 0)
	{
		LCD_DISP_SYS_ON(LBC_FFLASH,0,0);
		//ե0mmhg
		if(gbv_start_click)
		{
			gbv_start_click = 0;
			gu8v_public_count++;
//			u16	lu16v_adc_sum;
//			lu16v_adc_sum =0;
//			for(gu8v_public_time = 0;gu8v_public_time <16;gu8v_public_time ++)
//			{
//				lu16v_adc_sum += fun_Get_ADC(AN6);
//			}
//			gu16v_cal_0mmhg.u16 = lu16v_adc_sum/16;
			gu16v_cal_0mmhg.u16 = gu8a_PRESSURE_data_TEST;
			gu16v_zero.u16 = gu16v_cal_0mmhg.u16;
		}
		
		
		Uart_TX_RAW_DATA(0);  
		
		
		
	}
	else if(gu8v_public_count == 1)
	{
		LCD_DISP_SYS_ON(LBC_FLASH,300,0);
		//ե0mmhg
		if(gbv_start_click)
		{
			gbv_start_click = 0;
			gu8v_public_count++;	
//			u16	lu16v_adc_sum;
//			lu16v_adc_sum =0;
//			for(gu8v_public_time = 0;gu8v_public_time <16;gu8v_public_time ++)
//			{
//				lu16v_adc_sum += fun_Get_ADC(AN6);
//			}
//			gu16v_cal_300mmhg.u16 = lu16v_adc_sum/16;	
			gu16v_cal_300mmhg.u16 = gu8a_PRESSURE_data_TEST;
			
		}	
		Uart_TX_RAW_DATA(300);  				
	}
	else if(gu8v_public_count == 2)
	{
		//ܷeO
//		fun_cal_pressure(gu16v_pressure_output);
		LCD_DISP_SYS_ON(LBC_SET,gu16v_current_pressure.u16,0);
		//O_եҦ
		if(gbv_start_click)
		{
			Change_Mode(Sys_Normal_mode);
			gbv_start_click = 0;
			fun_CAL_WEEPROM();
			fun_LCD_all(00);
		}		
		Uart_TX_RAW_DATA(gu16v_current_pressure.u16);  			
	}
	else if(gu8v_public_count == 3)
	{
		
	}	
	else
	{
		
	}
	
	

}

/********************************************************************
Function:fun_CAL_WEEPROM
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	fun_CAL_WEEPROM()
{
	fun_Write_EEPROM(EEPROM_START_ADDR,0x55);
	fun_Write_EEPROM(EEPROM_300mmhg_H,gu16v_cal_300mmhg.byte.byte1);
	fun_Write_EEPROM(EEPROM_300mmhg_L,gu16v_cal_300mmhg.byte.byte0);	
	fun_Write_EEPROM(EEPROM_0mmhg_H,gu16v_cal_0mmhg.byte.byte1);	
	fun_Write_EEPROM(EEPROM_0mmhg_L,gu16v_cal_0mmhg.byte.byte0);
}

/********************************************************************
Function:fun_CAL_WEEPROM
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	fun_CAL_REEPROM()
{
	if(fun_Read_EEPROM(EEPROM_START_ADDR) == 0x55)
	{
		gu16v_cal_300mmhg.byte.byte1 = fun_Read_EEPROM(EEPROM_300mmhg_H);
		gu16v_cal_300mmhg.byte.byte0 =fun_Read_EEPROM(EEPROM_300mmhg_L);
		gu16v_cal_0mmhg.byte.byte1 =fun_Read_EEPROM(EEPROM_0mmhg_H);
		gu16v_cal_0mmhg.byte.byte0 =fun_Read_EEPROM(EEPROM_0mmhg_L);
		gu16v_zero.u16 = gu16v_cal_0mmhg.u16;
	}
	else
	{
		gu16v_cal_0mmhg.u16 = 384;//0x291;
		gu16v_cal_300mmhg.u16 = 3313;		
		gu16v_zero.u16 = gu16v_cal_0mmhg.u16;
	}
}


/********************************************************************
Function:fun_cal_pressure
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	fun_cal_pressure(u16 lu16v_pressure)
{
	if(lu16v_pressure >= gu16v_cal_0mmhg.u16)
	{
		gu16v_current_pressure.u16 = (u32)(lu16v_pressure-gu16v_cal_0mmhg.u16)*300/(gu16v_cal_300mmhg.u16-gu16v_cal_0mmhg.u16);
	}
	else
	{
		gu16v_current_pressure.u16 = 0;	
	}
}


/********************************************************************
Function:fun_cal_pressure
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	fun_auto_zero_pressure(u16 lu16v_pressure)
{
	if(lu16v_pressure >= gu16v_zero.u16)
	{
		gu16v_current_pressure.u16 = (u32)(lu16v_pressure-gu16v_zero.u16)*300/(gu16v_cal_300mmhg.u16-gu16v_cal_0mmhg.u16);
	}
	else
	{
		gu16v_current_pressure.u16 = 0;	
	}
	
	if(gu16v_current_pressure.u16>gu16v_pressure_output_old)
	{
		
		
	}
	
	
	if(gu16v_current_pressure.u16>gu16v_pressure_max)
	{
		gu16v_pressure_max=gu16v_current_pressure.u16;
	}
	if(gu16v_current_pressure.u16<gu16v_pressure_min)
	{
		gu16v_pressure_min=gu16v_current_pressure.u16;
	}	

	if((gu16v_pressure_max - gu16v_pressure_min)<2)
	{
		//lock
		gu8v_filter_guide ++;
		if(gu8v_filter_guide >=16)
		{
			gu8v_filter_guide = 16;
			gbv_pressure_lock = 1;
		}
	}
	else
	{
			gu8v_filter_guide = 0;
			gbv_pressure_lock = 0;
			gu16v_pressure_max = 0;
			gu16v_pressure_min = 300;					

	}
	
}


inline	void 	Sys_Comparison()
{

}

void	goto_halt()
{
	gu8v_halt_time = LU8C_HALT_TIME;
	gu8v_work_mode = 0;
}


u8	gu8v_lower_power_count;
	
/********************************************************************
Function:	Sys_lower_power
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void 	Sys_lower_power()
{	
	volatile u16 	gu16v_battery_ad;	
	if(gbv_250ms)
	{

		gu16v_battery_ad = ((u32)gu8v_BAT_ADC*133)/4096;//*3.3*13.3/(256*3.3);
		gu8v_battery_votage = (u8)gu16v_battery_ad;
		if(gu8v_battery_votage<43)	
		{
			gu8v_lower_power_count ++;
			if(gu8v_lower_power_count>5)
			{
				gu8v_lower_power_count = 5;
				if(gbv_bat_low == 0)
				{
					Change_Mode(Sys_BATERR_mode);
				}				
				gbv_bat_low = 1;
				
			}
			
			
		}	
		else
		{
			gu8v_lower_power_count = 0;
			
		}
		
	}
	
	if(gbv_bat_low)
	{
		LCD_ICON(LBC_FFLASH,LCD_Battery_ADDR);
		
	}
	else
	{
		LCD_ICON(LBC_CLR,LCD_Battery_ADDR);
	}	
	
}


/********************************************************************
Function:	Sys_lower_power
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void 	Sys_T1()
{
	//?T1
	//ܷeADCK
	LCD_DISP_SYS_ON(LBC_SET,gu16v_current_pressure.u16,0);
	switch(gu8v_public_count)
	{
		case	0:
			//Uset ?[?max ?O
			LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,2,Display_all_off,Display_t,Display_0);			
			
			if(gbv_set_down)
			{
				gu16v_pwm_target.u16 = STM0A_MAX/2;
				gu8v_public_time = 0;
			}
			if(gbv_set_press)
			{
				
				if(gu16v_pwm_target.u16<STM0A_MAX)
				{
					gu16v_pwm_target.u16 +=10;
					if(gu16v_pwm_target.u16>STM0A_MAX) 
					{
						gu16v_pwm_target.u16 = STM0A_MAX;
					}
					_stmal = gu16v_pwm_target.byte.byte0;
					_stmah = gu16v_pwm_target.byte.byte1 ;						
				}		
				
			 	if(gu16v_current_pressure.u16>300)
			 	{
			 		STP_PUMP_OFF();			 		
			 	}
			 	else
			 	{
			 		STP_PUMP_ON();
			 	}
				STP_VALUE_ON();
				
				if(gbv_500ms)
				{
					gu8v_public_time++;	
					if(gu8v_public_time>254)
					{
						gu8v_public_time = 254;
						
					}
				}			
				LCD_DISP_DIA_ON(LBC_SET,gu8v_public_time/2,0);					
				
			}
			else	if(gbv_memory_press)
			{
				if(gbv_500ms)
				{
					gu8v_public_time++;	
					if(gu8v_public_time>254)
					{
						gu8v_public_time = 254;
						
					}
				}			
				LCD_DISP_DIA_ON(LBC_SET,gu8v_public_time/2,0);					 

								
			}
			else
			{
			 	STP_PUMP_OFF();			 		
				//LCD_DISP_DIA_ON(LBC_CLR,gu8v_public_time/2,0);						
				
			}
			
			if(gbv_memory_down)
			{
				STP_VALUE_OFF();				
				gu8v_public_time = 0;
			}			
	
			if(gbv_start_click)
			{
				gbv_start_click = 0;
				gu8v_public_count++;
				gu8v_public_time = 0;
				gu16v_pwm_target.u16 = STM0A_MAX/2;	
				_stmal = gu16v_pwm_target.byte.byte0;
				_stmah = gu16v_pwm_target.byte.byte1 ;					
		 		STP_PUMP_ON();	
		 		STP_VALUE_OFF();
		 		gu8v_public_count1 = 0;		
		 		LCD_DISP_DIA_ON(LBC_CLR,gu8v_public_time/2,0);					
			}				
		break;	
		case	1:
			LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,2,Display_all_off,Display_t,Display_1);			

			//?300??
			LCD_DISP_SYS_ON(LBC_SET,gu16v_current_pressure.u16,0);			

			STP_VALUE_ON();
			
			if(gu8v_public_count1 ==0)
			{
				if(gu16v_pwm_target.u16<STM0A_MAX)
				{
					gu16v_pwm_target.u16 +=10;
					if(gu16v_pwm_target.u16>STM0A_MAX) 
					{
						gu16v_pwm_target.u16 = STM0A_MAX;
					}
					_stmal = gu16v_pwm_target.byte.byte0;
					_stmah = gu16v_pwm_target.byte.byte1 ;						
				}		
				
			 	if(gu16v_current_pressure.u16>260)
			 	{
			 		STP_PUMP_OFF();	
			 		gu8v_public_count1 = 1;		 		
			 	}
			 	else
			 	{
	
			 	}				
				
				if(gbv_500ms)
				{
					gu8v_public_time++;	
					if(gu8v_public_time>254)
					{
						gu8v_public_time = 254;
						
					}
				}			
				LCD_DISP_DIA_ON(LBC_SET,gu8v_public_time/2,0);					
			}
			else
			{
				
				
			}
			
			if(gbv_start_click)
			{
				gbv_start_click = 0;
				gu8v_public_count++;
				gu8v_public_time = 0;
				gu16v_pwm_target.u16 = STM0A_MAX/2;	
				_stmal = gu16v_pwm_target.byte.byte0;
				_stmah = gu16v_pwm_target.byte.byte1 ;					
		 		STP_PUMP_ON();	
		 		STP_VALUE_OFF();
		 		gu8v_public_count1 = 0;		
		 		LCD_DISP_DIA_ON(LBC_CLR,gu8v_public_time/2,0);				
			}			
							
			
		break;		
		case	2:
			LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,2,Display_all_off,Display_t,Display_2);			
			//?300?? na??
			LCD_DISP_SYS_ON(LBC_SET,gu16v_current_pressure.u16,0);			
			
			if(gu8v_public_count1 ==0)
			{
				if(gu16v_pwm_target.u16<STM0A_MAX)
				{
					gu16v_pwm_target.u16 +=10;
					if(gu16v_pwm_target.u16>STM0A_MAX) 
					{
						gu16v_pwm_target.u16 = STM0A_MAX;
					}
					_stmal = gu16v_pwm_target.byte.byte0;
					_stmah = gu16v_pwm_target.byte.byte1 ;						
				}		
				STP_VALUE_ON();
			 	if(gu16v_current_pressure.u16>260)
			 	{
			 		STP_PUMP_OFF();	
			 		STP_VALUE_OFF();
			 		gu8v_public_count1 = 1;		 		
			 	}
			 	else
			 	{
	
			 	}				
				
				
			}
			else
			{
				if(gu16v_current_pressure.u16>15)
				{
					if(gbv_500ms)
					{
						gu8v_public_time++;	
						if(gu8v_public_time>254)
						{
							gu8v_public_time = 254;
							
						}
					}			
					LCD_DISP_DIA_ON(LBC_SET,gu8v_public_time/2,0);						
				}

			}
			
			if(gbv_start_click)
			{
				gbv_start_click = 0;
				gu8v_public_count++;
				gu8v_public_time = 0;
				gu16v_pwm_target.u16 = STM0A_MAX/2;	
				_stmal = gu16v_pwm_target.byte.byte0;
				_stmah = gu16v_pwm_target.byte.byte1 ;					
		 		STP_PUMP_ON();	
		 		STP_VALUE_OFF();
		 		gu8v_public_count1 = 0;		
		 		LCD_DISP_DIA_ON(LBC_CLR,gu8v_public_time/2,0);					
			}	
		break;	
		
		case	3:
			LCD_DISP_LETTER_ON(LBC_HID+LBC_SET,2,Display_all_off,Display_t,Display_3);			
			//?300?? na??
			LCD_DISP_SYS_ON(LBC_SET,gu16v_current_pressure.u16,0);			

			
			if(gu8v_public_count1 ==0)
			{
				if(gu16v_pwm_target.u16<STM0A_MAX)
				{
					gu16v_pwm_target.u16 +=10;
					if(gu16v_pwm_target.u16>STM0A_MAX) 
					{
						gu16v_pwm_target.u16 = STM0A_MAX;
					}
					_stmal = gu16v_pwm_target.byte.byte0;
					_stmah = gu16v_pwm_target.byte.byte1 ;						
				}		
				STP_VALUE_ON();
			 	if(gu16v_current_pressure.u16>250)
			 	{
			 		STP_PUMP_OFF();	
			 		//STP_VALUE_OFF();
			 		gu8v_public_count1 = 1;		 		
			 	}
			 	else
			 	{
	
			 	}				
				
				
			}
			else
			{
				if(gu16v_current_pressure.u16>50)
				{
					if(gbv_500ms)
					{
						gu8v_public_time++;	
						if(gu8v_public_time>254)
						{
							gu8v_public_time = 254;
							
						}
					}			
					LCD_DISP_DIA_ON(LBC_SET,gu8v_public_time/2,0);						
				}

			}
			
			if(gbv_start_click)
			{
				gbv_start_click = 0;
				gu8v_public_count++;
				gu8v_public_time = 0;
				gu16v_pwm_target.u16 = STM0A_MAX/2;	
				_stmal = gu16v_pwm_target.byte.byte0;
				_stmah = gu16v_pwm_target.byte.byte1 ;					
		 		STP_PUMP_OFF();	
		 		STP_VALUE_OFF();
		 		gu8v_public_count1 = 0;		
		 		LCD_DISP_DIA_ON(LBC_CLR,gu8v_public_time/2,0);	
		 		Change_Mode(Sys_HALT_mode);				
			}	
			
			if(gbv_start_long_Press)
			{
				gbv_start_long_Press = 0;
				gu8v_public_count++;
				gu8v_public_time = 0;				
		 		STP_PUMP_OFF();	
		 		STP_VALUE_OFF();
		 		gu8v_public_count1 = 0;	
		 		
		 		
		 		
		 			
			
			}			
			
		break;			
		case	4:
			//`???
			gbv_loop_measure = 1;
			
			Change_Mode(Sys_Measure_mode);	
			Sys_init_heart_wave();
			//˴
			fun_battery_check();			
			
			
		break;				
		default:
		gu8v_public_count = 0;
		break;
	}
	
	
}


/********************************************************************
Function:	Sys_BATERR
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Sys_BATERR()
{
		STP_PUMP_OFF();
		STP_VALUE_OFF();
	//pGqL{U䰱աC
	if(gbv_start_click )
	{
		gbv_start_click = 0;
		Change_Mode(Sys_HALT_mode);
		STP_PUMP_OFF();
		STP_VALUE_OFF();							
	}	
	
}